% precompute:  Precompute filter coefficients and save to file
%
% precompute(i_name,o_name,mask)
%
%    i_name: Name of image file.
%    o_name: Name of output statistics file. (Can be large)
%    mask:   (OPTIONAL) 4x1 array [y1 y2 x1 x2] giving co-ordinates
%            of rectangle to be masked out during computation.
%
%  Note that this function should be called on linear / RAW
%  images. See preocmputeGC for gamma-corrected images.
function precompute(i_name,o_name,mask)
    
  img = double(imread(i_name));
  if max(img(:)) > 2^12
    sat = 2^16-1;
  else
    if max(img(:)) > 255
      sat = 2^12 -1;
    else
      sat = 255;
    end;
  end;
  
  % Compute mask - pixels that are not to be considered
  mimg = 1 - double(max(img,[],3) >= 0.95*sat);
  % Mask out ground truth if available
  if nargin == 3
    if length(mask) > 0
      mask = min(mask,[Inf size(mimg,1) Inf size(mimg,2)]);
      mimg(mask(1):mask(2),mask(3):mask(4)) = 0;
    end;
  end;

  stsg = [1 2 4];
  nbands = 2*length(stsg); fouts = cell(nbands,1); prc = zeros(nbands,1);
  
  idx = 1;
  for i = 1:length(stsg)
    thesg = stsg(i);
    szf = floor(thesg)*3;
    x = [-szf:szf];
    gf = exp(-x.^2/2/(thesg^2))/thesg;
    lgf = (x.^2- thesg^2)/(thesg^3) .* gf;
    mf = ones(size(lgf));
        
    mimg_i = dofilt(dofilt(mimg,mf),mf'); mimg_i = mimg_i < sum(mf)^2;
    mimg_i = mimg_i(:);
    
    fo = dofilt(dofilt(img,gf),lgf');
    
%     figure
%     imshow(2*fo/max(fo(:)))
    fo = reshape(fo,[prod(size(fo))/3 3]); fo(mimg_i,:) = []; 
    
    prc(idx) = max(fo(:)) / (2^15-1);
    fouts{idx} = int16(fo/prc(idx)); idx = idx + 1;
    
    fo = dofilt(dofilt(img,gf'),lgf); 
    fo = reshape(fo,[prod(size(fo))/3 3]); fo(mimg_i,:) = []; 
    prc(idx) = max(fo(:)) / (2^15-1);
    fouts{idx} = int16(fo/prc(idx)); idx = idx + 1;
    
%     fprintf('\r Computed %d of %d             ',idx-1,nbands);
  end
%   fprintf('\n');  
  save('-mat',o_name,'fouts','prc');
  
function a = dofilt(x,f)
  a = zeros([([size(x,1) size(x,2)]-size(f)+1) size(x,3)]);
  for i = 1:size(a,3)
    a(:,:,i) = conv2(x(:,:,i),f,'valid');
  end;
  